USE SSISDB
GO

-- Show task runtimes
SELECT execution_path
	, start_time, end_time, execution_duration
FROM catalog.executable_statistics
WHERE execution_id = (SELECT MAX(execution_id) FROM catalog.executions)
ORDER BY start_time

-- Show execution component phases
SELECT task_name, subcomponent_name, phase
	, SUM(DATEDIFF(MILLISECOND, start_time, end_time)) [Duration]
FROM catalog.execution_component_phases
WHERE execution_id = (SELECT MAX(execution_id) FROM catalog.executions)
GROUP BY task_name, subcomponent_name, phase
ORDER BY Duration DESC


-- Show row counts
SELECT task_name, source_component_name, destination_component_name
	, SUM(rows_sent) [rows_sent]
FROM catalog.execution_data_statistics
WHERE execution_id = (SELECT MAX(execution_id) FROM catalog.executions)
GROUP BY task_name, source_component_name, destination_component_name

SELECT task_name, source_component_name, destination_component_name, rows_sent
FROM catalog.execution_data_statistics
WHERE execution_id = (SELECT MAX(execution_id) FROM catalog.executions)
ORDER BY 1, 2, 3
